from collections import deque
def min_jumps(array, n):
    jumps = 0
    arr_length = len(array)
    jump_length = 0
    prev_safe = 0
    for i in range(0,arr_length):
        jump_length += 1
        if jump_length > n:
            break
        if(i == arr_length - 1 and jump_length < n):
            jumps += 1
            break
        if(array[i] == 1):
            prev_safe = i
            if(jump_length == n):
                jumps += 1
                jump_length = 0
        else:
            if(jump_length == n and prev_safe != 0):
                jumps += 1
                jump_length = n - (i - prev_safe)
    if jumps == 0:
        return -1
    return jumps


def platforms_visited(n, pairs, platforms, changes):
    all_visited_platforms = []

    for mouse in range(1, n + 1):
        if changes[mouse - 1] > 0:
            platforms[changes[mouse - 1] - 1] = 1 - platforms[changes[mouse - 1] - 1]
        graph = {i: [] for i in range(1, n + 1)}
        for pair in pairs:
            graph[pair[1]].append(pair[0])

        visited_platforms_by_mouse = []

        queue = deque([(mouse, mouse)])
        visited_rooms = set()
        while queue:
            current_room, remaining_strength = queue.popleft()
            if current_room in visited_rooms:
                continue
            visited_rooms.add(current_room)
            for next_room in graph[current_room]:
                if platforms[next_room - 1] == 1 or remaining_strength > 0:
                    visited_platforms_by_mouse.append(platforms[next_room - 1])
                    queue.append((next_room, remaining_strength - 1))
                else:
                    visited_platforms_by_mouse.append(platforms[next_room - 1])
                    for next_next_room in graph[next_room]:
                        if next_next_room not in visited_platforms_by_mouse:
                            visited_platforms_by_mouse.append(platforms[next_next_room - 1])
                            queue.append((next_next_room, remaining_strength - 2))
        visited_platforms_by_mouse.append(1)
        all_visited_platforms.append(visited_platforms_by_mouse)

    return all_visited_platforms


pairs = []
n = int(input())
for i in range(0,n - 1):
    pairs.append(list(map(int,input().split(' '))))
platforms = list(map(int,input().split(' ')))
changes = list(map(int,input().split(' ')))
result = platforms_visited(n, pairs, platforms,changes)
i = 0
out_list = []
for res in result:
    i += 1
    out_list.append(str(min_jumps(res,i)))
print(' '.join(out_list))